/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "custdomcombobox.h"
#include <QDebug>

CustdomComboBox::CustdomComboBox(QWidget *parent) :
    QComboBox(parent)
{
    QSize maxSize(422, 62);
    QSize minSize(320, 50);
    this->setMinimumSize(minSize);
//    this->setMaximumSize(maxSize);
    connect(this, SIGNAL(currentIndexChanged(int)), this, SLOT(itemchangedSlot(int)));
}

CustdomComboBox::~CustdomComboBox()
{
}

void CustdomComboBox::itemchangedSlot(int itemindex){
    if (CustdomComboBox::currentText() == "add")
        qDebug() << "---------------->";

    emit itemchangedSignal(itemindex);
}
