## Type of Change
- [ ] Bug fix
- [ ] New feature
- [ ] Breaking change
- [ ] Documentation update

## Description
Please include a summary of the changes and the related issue. Also, include relevant motivation and context.

Bug Fix: [Brief description of the bug fixed]
Root Cause (if applicable): [Explain what caused the bug]
Fix Implemented: [Describe the fix applied]

Enhancement: [Brief description of the improvement/enhancement made]
Enhancement Description: [Explain what was enhanced, why, and how]
Impact Area: [Mention which part of the system/codebase is affected]

Testing Done:
- [] Manual testing
- [] Unit tests
- [] Integration tests

Test cases covered: [Mention test case IDs or brief points]

## Checklist
- [ ] My code follows the style guidelines of this project
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published in downstream modules
- [ ] All the sanity checks have been completed and the sanity test cases have been executed

## Ansible Best Practices
- [ ] Tasks are idempotent (can be run multiple times without changing state)
- [ ] Variables and secrets are handled securely (e.g., using `ansible-vault` or environment variables)
- [ ] Playbooks are modular and reusable
- [ ] Handlers are used for actions that need to run on change

## Documentation
- [ ] All options and parameters are documented clearly.
- [ ] Examples are provided and tested.
- [ ] Notes and limitations are clearly stated.

## Screenshots (if applicable)

## Notes to Reviewers

